<?php

return [
    'name' => 'Catalog',

    'disk' => 's3',

    /**
     * When there is only one active catalog in the database, should we redirect to that one directly? Or display the
     * catalog index page and ask the user to click on the catalog?
     */
    'redirect_when_only_one' => true,

    /**
     * On the catalog vendor index page and item page, should we display the type of item e.g. giftcard, egift etc
     * as a 'ribbon' on the item image?
     */
    'display_type_ribbon' => true,

    /**
     * On the catalog vendor index page, how many items should we display per page.
     */
    'per_page' => 15,

    /**
     * The default global point value conversion rate. Point value can also be changed per item.
     */
    'default_point_value' => 0.05,

    /**
     * The default global price margin. Price margin can also be changed per item.
     */
    'default_price_margin' => 13.04,

    'order' => [
        'prefix' => env('CATALOG_ORDER_PREFIX', 'IG0000_'),
        'padding' => env('CATALOG_ORDER_PADDING', 6),
        /** TO:DO Fallback to mail.bcc.email instead of mail_from_address once we update core's bcc implemation  */
        'confirmation_bcc' => [
            'enabled' => env('CATALOG_ORDER_CONFIRMATION_BCC_ENABLED', true),
            'address' => env('CATALOG_ORDER_CONFIRMATION_BCC_ADDRESS', env('MAIL_FROM_ADDRESS', 'itlogs@brightspot.email'))
        ],
    ],

    'vendors' => [
        'hawk' => [
            // CATALOG_HAWK_TEST_MODE: if true, the catalog will connect to pre-prod Hawk
            // server with the integration cert and keys, otherwise it connects
            // to their production server with production the cert and key.
            // Also if it is true, it replaces all product_id with the
            // configured test product id upon ordering.
            'test_mode' => env('CATALOG_HAWK_TEST_MODE', 'production' !== env('APP_ENV')),
            'merchant_id' => env('CATALOG_HAWK_MERCHANT_ID'),
            // CATALOG_HAWK_CERT and CATALOG_HAWK_KEY will generate default file path if left empty
            'cert' => env('CATALOG_HAWK_CERT'),
            'key' => env('CATALOG_HAWK_KEY'),
            'prepaid' => [
                'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_PREPAID_TEST_ID', '95016709'),
                'payment_type' => env('CATALOG_HAWK_PREPAID_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'financialAccountId' => env('CATALOG_HAWK_PREPAID_FINANCIAL_ACCOUNTID'),
                'description' => env('CATALOG_HAWK_PREPAID_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_PREPAID_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                'card_carrier_message' => env('CATALOG_HAWK_PREPAID_CARD_CARRIER_MESSAGE', 'Congratulations on your award!'),
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
                'anonymous' => [
                    'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                    'bulk' => [
                        'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                        'test_product_id' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_TEST_ID', '95016709'),
                        'description' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_DESCRIPTION', 'Prepaid Visa Card'),
                        'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', \Ignite\Vendor\Hawk\ShippingMethod::UPS_GROUND),
                        'payment_type' => env('CATALOG_HAWK_PREPAID_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                        'clientRefId' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_CLIENT_REF_ID', ''),
                        'fourthLineEmbossText' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_FOURTH_LINE_TEXT', env('CATALOG_HAWK_PREPAID_FOURTH_LINE_EMBOSS', 'THANK YOU')),
                    ]
                ]
            ],
            'reloadable' => [
                'enabled' => env('CATALOG_HAWK_RELOADABLE_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_RELOADABLE_TEST_ID', '95003157'),
                'payment_type' => env('CATALOG_HAWK_RELOADABLE_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'financialAccountId' => env('CATALOG_HAWK_RELOADABLE_FINANCIAL_ACCOUNTID'),
                'description' => env('CATALOG_HAWK_RELOADABLE_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_RELOADABLE_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                // card_carrier_message - this cannot exceed 80 characters
                'card_carrier_message' => env('CATALOG_HAWK_RELOADABLE_CARD_CARRIER_MESSAGE', 'Congratulations on your award!'),
                'shipping_method' => env('CATALOG_HAWK_RELOADABLE_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
                // CATALOG_HAWK_RELOADABLE_ID_PREFIX should be unique to each program, and is recommended be 3 to 5
                // characters with a _ at the end. I also do NOT recommend using the project code since the project
                // code changes each year, but we do not want the reloadable prefix to change each year because it
                // sticks with a participant for their card. The production prefix should be different from
                // non-production just in case.
                'recipient_id_prefix' => env('CATALOG_HAWK_RELOADABLE_ID_PREFIX'),
                'identity_column' => 'user_id',
                // if we want to maintain the min threshold; should be in US dollar amount
                'min_threshold_initial' => 5,
                'min_threshold_reload' => 5,
                'sku' => 'visa_reloadable_us',
                'sku_us' => 'visa_reloadable_us',
                'sku_ca' => 'visa_reloadable_ca',
            ],
            'giftcard' => [
                'enabled' => env('CATALOG_HAWK_GIFTCARD_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_GIFTCARD_TEST_ID', '43507508'),
                'payment_type' => env('CATALOG_HAWK_GIFTCARD_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'financialAccountId' => env('CATALOG_HAWK_GIFTCARD_FINANCIAL_ACCOUNTID'),
            ],
            'egift' => [
                'enabled' => env('CATALOG_HAWK_EGIFT_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_EGIFT_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_EGIFT_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'financialAccountId' => env('CATALOG_HAWK_EGIFT_FINANCIAL_ACCOUNTID'),
                'senderName' => env('CATALOG_HAWK_EGIFT_SENDER_NAME', env('APP_NAME', 'Ignite Catalog Rewards')),
                'senderEmail' => env('CATALOG_HAWK_EGIFT_SENDER_EMAIL', env('CATALOG_EMAIL', env('MAIL_FROM_ADDRESS', 'it@brightspot.email'))),
                'subject' => env('CATALOG_HAWK_EGIFT_SUBJECT', 'Your '.env('APP_NAME', 'Ignite Catalog Rewards').' eGift is enclosed'),
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_EGIFT_MESSAGE', ''),
                'emailClosingName' => env('CATALOG_HAWK_EGIFT_SENDER_NAME', env('APP_NAME', 'Reward Headquarters')),
            ],
            'virtual' => [
                'enabled' => env('CATALOG_HAWK_VIRTUAL_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_VIRTUAL_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_VIRTUAL_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'financialAccountId' => env('CATALOG_HAWK_VIRTUAL_FINANCIAL_ACCOUNTID'),
                'senderName' => env('CATALOG_HAWK_VIRTUAL_SENDER_NAME', env('APP_NAME', 'Ignite Rewards')),
                'senderEmail' => env('CATALOG_HAWK_VIRTUAL_SENDER_EMAIL', env('CATALOG_EMAIL', env('MAIL_FROM_ADDRESS', 'it@brightspot.email'))),
                'subject' => env('CATALOG_HAWK_VIRTUAL_SUBJECT', 'Your '.env('APP_NAME', 'Catalog Rewards').' - Virtual Order'),
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_VIRTUAL_MESSAGE', ''),
                'emailClosingName' => env('CATALOG_HAWK_VIRTUAL_SENDER_NAME', env('APP_NAME', 'Reward Headquarters')),
            ],
            'unsubscribe' => [
                'company' => env('CATALOG_HAWK_COMPANY_NAME', env('APP_NAME', 'Ignite Catalog Rewards')),
                'address1' => '102 Decker Ct Suite 150',
                'city' => 'Irving',
                'state' => 'TX',
                'zip' => '75062',
                'country' => 'US',
                'type' => 'EMAIL',
                'value' => env('CATALOG_HAWK_UNSUBSCRIBE_EMAIL', env('MAIL_FROM_ADDRESS', 'it@brightspot.email'))
            ],
            'thirdParty' => [
                // these you can set through the environment variables in the .env file
                // or just overwrite them here
                'company' => env('CATALOG_HAWK_THIRDPARTY_COMPANY', env('CATALOG_HAWK_COMPANY_NAME', '')),
                'contact' => env('CATALOG_HAWK_THIRDPARTY_CONTACT', env('CATALOG_HAWK_COMPANY_CONTACT_NAME', '')),
                'address1' => env('CATALOG_HAWK_THIRDPARTY_ADDRESS1', ''),
                'address2' => env('CATALOG_HAWK_THIRDPARTY_ADDRESS2', ''),
                'address3' => env('CATALOG_HAWK_THIRDPARTY_ADDRESS3', ''),
                'city' => env('CATALOG_HAWK_THIRDPARTY_CITY', ''),
                'region' => env('CATALOG_HAWK_THIRDPARTY_REGION', ''),
                'postalCode' => env('CATALOG_HAWK_THIRDPARTY_POSTALCODE', ''),
                'postalCodeExt' => env('CATALOG_HAWK_THIRDPARTY_POSTALCODEEXT', ''),
                // country must be the 3 character alphabetic ISO code
                'country' => env('CATALOG_HAWK_THIRDPARTY_COUNTRY', ''),
                // though you can add the tax id here, since it is sensitive information,
                // it is better to put it in the .env file with CATALOG_HAWK_THIRDPARTY_TAXID
                // since that is not committed to the repository.
                // it needs to be a 9 digit number.
                'taxId' => env('CATALOG_HAWK_THIRDPARTY_TAXID', env('CATALOG_HAWK_PREPAID_TAX_ID')),
            ],
            'schema' => [
                [
                    'name' => 'product_id',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Product ID'
                ], [
                    'name' => 'content_provider_code',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Content Provider Code'
                ],
                /*
                [
                    'name' => 'payment_type',
                    'type' => 'select',
                    'rules' => 'required',
                    'label' => 'Payment Type',
                    'choices' => [
                        '' => 'Please choose a payment type',
                        Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT => 'ACH DEBIT',
                        Ignite\Vendor\Hawk\PaymentType::ACH_CREDIT => 'ACH CREDIT',
                        Ignite\Vendor\Hawk\PaymentType::CREDIT_CARD => 'CREDIT CARD',
                        Ignite\Vendor\Hawk\PaymentType::WIRE_TRANSFER => 'WIRE TRANSFER',
                        Ignite\Vendor\Hawk\PaymentType::DRAW_DOWN => 'DRAW DOWN',
                        Ignite\Vendor\Hawk\PaymentType::BUSINESS_CHECK => 'BUSINESS CHECK',
                        Ignite\Vendor\Hawk\PaymentType::POST_PAY => 'POST PAY',
                    ],
                ],
                */
            ]
        ],

        'tango' => [
            'test' => [
                'enabled' => env('CATALOG_TANGO_TEST_MODE', 'production' !== env('APP_ENV')),
                'platform' => env('CATALOG_TANGO_TEST_PLATFORM', 'BrightspotTEST'),
                'api_key' => env('CATALOG_TANGO_TEST_APIKEY', 'lt?JqJyhFFWyXljf&lWrevftZQORQRTqwqZdYNV@XMYo'),
                'customer_identifier' => 'G53986245', // BrightspotTEST
                'use_test_card' => true,
                'account_identifier' => 'A17758085', // BrightspotTEST
                'etid' => 'E000000', // Tango Card Standard Template
                'utid' => 'U163059', // USD: Amazon.com Gift Card
                'amount' => 10,
            ],
            'platform' => env('CATALOG_TANGO_PLATFORM'),
            'api_key' => env('CATALOG_TANGO_APIKEY'),
            'customer_identifier' => 'G22546277', // Brightspot Primary
            // email_subject: usually leave empty to use defaults on the email template
            'email_subject' => null,
            // message: usually leave empty to use defaults on the email template
            'message' => null,
            'notes' => null,
            'send_email' => true,
            'sender' => [
                'email' => env('CATALOG_TANGO_SENDER_EMAIL', env('CATALOG_EMAIL', env('MAIL_FROM_ADDRESS', 'it@brightspot.email'))),
                'firstname' => env('CATALOG_TANGO_SENDER_FIRST', env('APP_NAME', 'Ignite Catalog Rewards')),
                'lastname' => env('CATALOG_TANGO_SENDER_LAST'),
            ],
            'egift' => [
                'enabled' => env('CATALOG_TANGO_EGIFT_ENABLED', false),
            ],
        ],

        // @deprecated: I dont think this is used anywhere
        'brightspot' => [
            "name" => "brightspot",
            "type" => "merchandise",
            "image_path" => "catalog/brightspot",
            "vendor_countries" => "US",
            "redemption_class" => Ignite\Catalog\Vendors\NullProcessor::class,
            "active" => 1
        ]
    ],

    'brightspot' => [
        "name" => "International Merchandise Catalog",
        "code" => "brightspot",
        "type" => "merchandise",
        "description" => "Example International merchandise catalog.",
        "countries" => "US",
        "active" => 1,
    ],

    'product' => [
        'types' => [
            'merchandise' => Ignite\Catalog\Models\Product\Classifications\Merchandise::class,
            'giftcard' => Ignite\Catalog\Models\Product\Classifications\Card::class,
            'egift' => Ignite\Catalog\Models\Product\Classifications\Egift::class,
            'prepaid' => Ignite\Catalog\Models\Product\Classifications\Prepaid::class,
            'reloadable' => Ignite\Catalog\Models\Product\Classifications\Reloadable::class,
            'prepaid.anonymous.bulk' => Ignite\Catalog\Models\Product\Classifications\PrepaidAnonymousBulk::class,
            'virtual' => Ignite\Catalog\Models\Product\Classifications\Virtual::class,
        ]
    ],

    'report' => [
        'filters' => [
            Ignite\Catalog\Models\Report\OrderReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order.created_at',
                    'options' => []
                ]
            ],
            Ignite\Catalog\Models\Report\OrderItemReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order_item.created_at',
                    'options' => []
                ]
            ]
        ]
    ]
];
