<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Vendors\VendorHandler;
use Illuminate\Support\Collection;

class PrepaidAnonymousBulk extends VendorHandler
{
    /**
     * @inheritdoc
     */
    public function enabled(): bool
    {
        return (bool)config('catalog.vendors.hawk.prepaid.anonymous.bulk.enabled')
            ?? (bool)config('catalog.vendors.hawk.prepaid.anonymous.enabled')
            ?? (bool)config('catalog.vendors.hawk.prepaid.enabled');
    }

    /**
     * @inheritdoc
     */
    protected function job(Order $order, Collection $orderItems)
    {
        return \Ignite\Catalog\Jobs\Hawk\PrepaidAnonymousBulk::class;
    }
}
