<?php

namespace Ignite\Catalog\Http\Forms;

use Ignite\Catalog\Entities\Vendor;
use Kris\LaravelFormBuilder\Form;

class CatalogForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('internal_name', 'text', $this->getInternalNameOptions());
        $this->add('name', 'text', $this->getNameOptions());
        //$this->add('code', 'text', $this->getCodeOptions());
        $this->add('type', 'select', $this->getTypeOptions());
        $this->add('catalog_vendor_id', 'select', $this->getVendorOptions());
        $this->add('countries', 'choice', $this->getCountriesOptions());
        $this->add('description', 'textarea', $this->getDescriptionOptions());
        $this->add('active', 'toggle', $this->getActiveOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the internal name field.
     *
     * @return array
     */
    protected function getInternalNameOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.internal_name.label'),
            'rules' => 'min:2|max:255'
        ];
    }

    /**
     * The options for the name field.
     *
     * @return array
     */
    protected function getNameOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.name.label'),
            'rules' => 'required|min:2|max:255'
        ];
    }

    /**
     * The options for the name field.
     *
     * @return array
     */
    protected function getCodeOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.code.label'),
            'rules' => 'required|min:2|max:255'
        ];
    }

    /**
     * The options for the type field.
     *
     * @return array
     */
    protected function getTypeOptions()
    {
        return [
            'attr' => ['class' => 'form-control select2'],
            'rules' => 'max:50',
            'label' => trans('Catalog::catalog.fields.type.label'),
            'choices' => [
                'card' => 'Card',
                'merchandise' => 'Merchandise'
            ]
        ];
    }

    /**
     * The options for the image path field.
     *
     * @return array
     */
    protected function getVendorOptions()
    {
        return [
            'attr' => ['class' => 'form-control select2'],
            'rules' => 'max:255',
            'label' => trans('Catalog::catalog.fields.vendor.label'),
            'choices' => Vendor::all()->keyBy('id')->map(function ($vendor) {
                return ucwords($vendor->name);
            })->toArray()
        ];
    }

    /**
     * The options for the vendor countries field.
     *
     * @return array
     */
    protected function getCountriesOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.countries.label'),
            'attr' => ['class' => 'form-control select2'],
            'rules' => 'max:255',
            'multiple' => true,
            'expanded' => false,
            'choices' => [
                'US' => 'USA',
                'CA' => 'Canada'
            ],
            'selected' => function ($data) {
                // Returns the array of short names from model relationship data
                return explode(',', $data);
            }
        ];
    }

    /**
     * The options for the redemption class field.
     *
     * @return array
     */
    protected function getDescriptionOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.description.label'),
            'rules' => 'max:255'
        ];
    }

    /**
     * The options for the redemption class field.
     *
     * @return array
     */
    protected function getActiveOptions()
    {
        return [
            'label' => trans('Catalog::catalog.fields.active.label'),
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::catalog.fields.save.label'),
        ];
    }
}
