<?php

namespace Ignite\Catalog\Events;

use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\OrderItem;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class IncompleteTangoOrder
{
    use Dispatchable, SerializesModels;

    /**
     * @var Order
     */
    public $order;

    /**
     * @var OrderItem
     */
    public $orderItem;

    /**
     * @var string
     */
    public $requestId;

    /**
     * Create a new event instance.
     *
     * @param Order $order
     * @param OrderItem $orderItem
     * @param string $requestId
     */
    public function __construct(Order $order, OrderItem $orderItem, string $requestId)
    {
        $this->order = $order;
        $this->orderItem = $orderItem;
        $this->requestId = $requestId;
    }
}
