<?php

namespace Ignite\Catalog\Models;

use Ignite\Core\Entities\Exception;
use Ignite\Catalog\Emails\OrderEmail;

class OrderEmailSender
{
    public function handleEmailEvent($event)
    {
        $eventType  = $event->eventType;

        if (empty($event->data)) {
            $error = sprintf("data field not set for '%s' event, can't process email.", $eventType);
            throw (new Exception($error));
            return false;
        }

        $data = $event->data;

        // ---------------------------------------
        // Get Appropriate Settings for this Type of Email
        // ---------------------------------------
        $emailSettingKey    = 'catalog.email.' . $eventType;
        $emailSettings      = setting($emailSettingKey);

        if (empty($emailSettings)) {
            // printf("no Email Settings setup for event type '%s', ignored...<br />\n", $eventType);
            return false;
        }

        $emailParams        = json_decode($emailSettings);

        if (empty($emailParams)) {
            $error = sprintf("Could not decode email settings for key '%s', can't process email.", $emailSettingKey);
            throw (new Exception($error));
            return false;
        }

        if (empty($emailParams->template)) {
            $error = sprintf("No email template configured for '%s' event, can't process email.", $eventType);
            throw (new Exception($error));
            return false;
        }

        if (empty($emailParams->template)) {
            $error = sprintf("No subject configured for '%s' event, can't process email.", $eventType);
            throw (new Exception($error));
            return false;
        }

        // ---------------------------------------
        // Add Email Settings to Data before sending Email
        // ---------------------------------------
        $emailActive    = (! empty($emailParams->active))     ? $emailParams->active      : 0;
        $template       = $emailParams->template;
        $subject        = $emailParams->subject;

        $subject = $this->parseInFields($subject, $data);

        if (! $emailActive) {
            return false;
        }

        $fromEmail  = config('mail.from.address');
        $fromName   = config('mail.from.name');
        $toEmail    = $data['email_participant']['email'];
        $toName     = (! empty($data['email_participant'])) ? $data['email_participant']['first'] . ' ' . $data['email_participant']['last'] : '';
        $name       = (! empty($toName)) ? $toName : 'Rewards Program Participant';

        // ---------------------------------------
        // Check for To Email Address override
        // ---------------------------------------
        $toEmail    = (! empty($data['email_settings']['toEmail'])) ? $data['email_settings']['toEmail'] : $toEmail;

        $data['email_settings'] = [];
        $data['email_settings']['eventType']    = $eventType;
        $data['email_settings']['eventActive']  = $emailActive;
        $data['email_settings']['template']     = $template;
        $data['email_settings']['name']         = $name;
        $data['email_settings']['toEmail']      = $toEmail;
        $data['email_settings']['toName']       = $toName;
        $data['email_settings']['fromEmail']    = $fromEmail;
        $data['email_settings']['fromName']     = $fromName;
        $data['email_settings']['subject']      = $subject;
        // print_r($data['email_settings']);
        // printf("name: '%s'\n", $data['email_settings']['name']);

        // ---------------------------------------
        // Send Email
        // ---------------------------------------
        if (! empty($emailParams->active)) {
            \Mail::send(new OrderEmail($data));
        }

        return true;
    }

    private function parseInFields($string, $data)
    {
        $parsedString = $string;

        $pattern = '~\{[A-z0-9_]+\}~';
        $rc = preg_match_all($pattern, $string, $matches);

        foreach ($matches[0] as $match) {
            $varName = trim($match, '{}');

            $knownVariable = false;

            switch ($varName) {
                case 'order_id':
                    $value = $data['id'];
                    $knownVariable = true;
                    break;

                default:
                    break;
            }
        }

        if ($knownVariable) {
            $parsedString = str_replace($match, $value, $parsedString);
        }

        return $parsedString;
    }
}
