<?php

namespace Ignite\Catalog\Http\Views;

use Illuminate\View\View;
use Ignite\Catalog\Contracts\FavoriteRepository;
use Ignite\Catalog\Entities\CartItem;
use Ignite\Catalog\Models\Cart;

class CatalogCountsComposer
{
    /**
     * @var Cart
     */
    private $cart;

    /**
     * @var FavoriteRepository
     */
    private $favorites;


    /**
     * CatalogCountsComposer constructor.
     *
     * @param Cart $cart
     * @param FavoriteRepository $favoriteRepository
     */
    public function __construct(Cart $cart, FavoriteRepository $favoriteRepository)
    {
        $this->cart = $cart;
        $this->favorites = $favoriteRepository;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with('countCart', $this->cart->count());
        $view->with('countFavorites', $this->favorites->count());
    }
}
