<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class CategoryForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('name', 'text', $this->getNameOptions());
        $this->add('code', 'text', $this->getCodeOptions());
        $this->add('image', 'file', $this->getImageOptions());
        $this->add('icon', 'icon', $this->getIconOptions());
        $this->add('description', 'textarea', $this->getDescriptionOptions());
        $this->add('active', 'toggle', $this->getActiveOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the name field.
     *
     * @return array
     */
    protected function getNameOptions()
    {
        return [
            'rules' => 'required|min:2|max:255',
            'label' => trans('Catalog::category.fields.name.label')
        ];
    }

    /**
     * The options for the code field.
     *
     * @return array
     */
    protected function getCodeOptions()
    {
        return [
            'rules' => 'required|min:2|max:255',
            'label' => trans('Catalog::category.fields.code.label')
        ];
    }

    /**
     * The options for the image field.
     *
     * @return array
     */
    protected function getImageOptions()
    {
        return [
            'rules' => 'image',
            'label' => trans('Catalog::category.fields.image.label')
        ];
    }

    /**
     * The options for the icon field.
     *
     * @return array
     */
    protected function getIconOptions()
    {
        return [
            'rules' => 'max:255',
            'label' => trans('Catalog::category.fields.icon.label'),
            'attr' => ['autocomplete' => 'off']
        ];
    }

    /**
     * The options for the description field.
     *
     * @return array
     */
    protected function getDescriptionOptions()
    {
        return [
            'rules' => 'max:500',
            'label' => trans('Catalog::category.fields.description.label')
        ];
    }

    /**
     * The options for the active field.
     *
     * @return array
     */
    protected function getActiveOptions()
    {
        return [
            'label' => trans('Catalog::category.fields.active.label')
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::category.fields.save.label')
        ];
    }
}
