<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusColumnToCatalogItemTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('catalog_cart_item', function (Blueprint $table) {
            $table->tinyInteger('status')->default(1)->nullable()->after('points');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasColumn('catalog_cart_item', 'status')) {
            Schema::table('catalog_cart_item', function (Blueprint $table) {
                $table->dropColumn('status');
            });
        }
    }
}
