<?php

namespace Ignite\Catalog\Models\Options;

use Ignite\Catalog\Entities\Vendor;
use Ignite\Core\Contracts\Source;

class Vendors implements Source
{
    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        return Vendor::all()->keyBy('id')->map(function ($vendor) {
            return ucwords($vendor->name);
        })->toArray();
    }
}
