<?php

namespace Ignite\Catalog\Http\Requests;

use Ignite\Catalog\Models\ReloadableThreshold;
use Illuminate\Foundation\Http\FormRequest;

class CreateReloadableRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @param  ReloadableThreshold $threshold
     * @return array
     */
    public function rules(ReloadableThreshold $threshold): array
    {
        $rules = [
            'item_id' => 'required',
            'amount' => 'required|integer',
        ];

        if (! $threshold->hasCreatedReloadableCard()) {
            $rules['info.ship_phone'] = 'required';
            $rules['info.ship_email'] = 'nullable|email:rfc,filter';
            $rules['info.ship_address_1'] = 'required';
            $rules['info.ship_city'] = 'required';
            $rules['info.ship_state'] = 'required';
            $rules['info.ship_postal'] = 'required';
        }

        return $rules;
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages(): array
    {
        return [
            'amount.required' => 'Load amount is required',
            'amount.integer' => 'Load amount is a number (no commas or decimal points)',
            'info.ship_phone.required'  => 'The phone number is required',
            'info.ship_phone.numeric'  => 'The phone number must be numeric',
            'info.ship_email.email'  => 'The email address must be a valid format',
            'info.ship_address_1.required'  => 'The address line 1 is required',
            'info.ship_city.required'  => 'The city is required',
            'info.ship_state.required'  => 'The state is required',
            'info.ship_postal.required'  => 'The postal code/zip is required',
        ];
    }
}
