<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogItemOptionTable extends Migration
{
    protected $tableName = 'catalog_item_option';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('super_id')->nullable();
            $table->unsignedInteger('item_id')->nullable();
            $table->unsignedInteger('attribute_id')->nullable();
            $table->string('label', 255);
            $table->string('value', 255);
            $table->unsignedInteger('position');
            $table->timestamps();
            $table->foreign('super_id')->references('id')->on('catalog_item');
            $table->foreign('item_id')->references('id')->on('catalog_item');
            $table->foreign('attribute_id')->references('id')->on('catalog_attribute');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
