<?php

namespace Ignite\Catalog\Jobs\Hawk;

use Ignite\Catalog\Events\CompleteHawkOrder;
use Ignite\Catalog\Jobs\ProcessManager as BaseProcessManager;
use Ignite\Vendor\Hawk\Response\BaseOrderResponse;
use InvalidArgumentException;

class ProcessManager extends BaseProcessManager
{
    /**
     * Complete the order.
     *
     * @param BaseOrderResponse $response
     * @param array $meta
     *
     * @return bool
     */
    public function complete($response, array $meta = [])
    {
        parent::complete($response, $meta);
        CompleteHawkOrder::dispatch($this->order, $this->orderItem, $response, $this->requestId);

        return true;
    }

    /**
     * Gets the order number from the response.
     *
     * @param  array  $meta
     * @return null|string
     */
    protected function getResponseOrderNumber(array $meta)
    {
        if (empty($meta['attempts'])) {
            return null;
        }

        $attempts = array_reverse($meta['attempts']);
        foreach ($attempts as $attempt) {
            if (empty($attempt['response']['orderNumber'])) {
                continue;
            }
            return $attempt['response']['orderNumber'];
        }
    }

    /**
     * Determine whether the order response is complete.
     *
     * @param BaseOrderResponse $response
     *
     * @return bool
     */
    public function isOrderComplete($response)
    {
        if (!$response instanceof BaseOrderResponse) {
            throw new InvalidArgumentException('Response must be an instance of ' . BaseOrderResponse::class);
        }

        return $response->getIsCompleted() && $response->getSuccess();
    }
}
