<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Core\Models\Grid\QueryTable;
use Yajra\DataTables\DataTables;

class AttributesTable extends QueryTable
{
    /**
     * @var AttributeFormatter
     */
    protected $formatter;

    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    /**
     * AttributesTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param AttributeFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        AttributeFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => trans('Core::core.common.actions'),
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => trans('Catalog::attribute.fields.id.label'),
                'name' => 'catalog_attribute.id',
                'orderable' => true,
                'exportable' => true,
            ],
            'label' => [
                'title' => trans('Catalog::attribute.fields.label.label'),
                'name' => 'catalog_attribute.label',
                'orderable' => true,
                'exportable' => true,
            ],
            'code' => [
                'title' => trans('Catalog::attribute.fields.code.label'),
                'name' => 'catalog_attribute.code',
                'orderable' => true,
                'exportable' => true,
            ],
            'type' => [
                'title' => trans('Catalog::attribute.fields.type.label'),
                'name' => 'catalog_attribute.type',
                'orderable' => true,
                'exportable' => true,
            ],
            'use_in_filter' => [
                'title' => trans('Catalog::attribute.fields.use_in_filter.label'),
                'name' => 'catalog_attribute.use_in_filter',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => trans('Catalog::attribute.fields.created_at.label'),
                'name' => 'catalog_attribute.created_at',
                'orderable' => true,
                'exportable' => true,
                'visible' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions', 'checkbox')
            ->keys()
            ->toArray();

        $query = $this->getConnection()
            ->table('catalog_attribute')
            ->select($columns);

        return $query;
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'action' => [$this->formatter, 'actions'],
            'use_in_filter' => [$this->formatter, 'useInFilter'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'] // ID
        ], $this->getCheckboxColumnParameters());
    }
}
