<?php

namespace Ignite\Catalog\Contracts;

use Ignite\Core\Entities\User;

interface OrderRepository
{
    /**
     * The most basic cart query.
     *
     * @param  array $relations
     * @return \Illuminate\Database\Eloquent\Builder?
     */
    public function query($relations = []);

    /**
     * Find all cart items. Not scoped by user.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAll();

    /**
     * Find all cart items. Not scoped by user.
     *
     * @param  int|User $user
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAllByUser($user);

    /**
     * Find an order by number.
     *
     * @param  string $number
     * @param  null|int|User $user
     * @return \Ignite\Catalog\Entities\Order
     */
    public function find($number, $user = null);

    /**
     * Find orders by logged in user.
     *
     * @param  string $number
     * @return \Ignite\Catalog\Entities\Order
     */
    public function findByLoggedInUser($number);

    /**
     * Create a new order.
     *
     * @param  array $data
     * @param  \Illuminate\Support\Collection $items
     * @param  int $total
     * @return \Ignite\Catalog\Entities\Order
     */
    public function create($data, $items, $total);

    /**
     * Cancel the order.
     *
     * @param  string $number
     * @return \Ignite\Catalog\Entities\Order
     */
    public function cancel($number);

    /**
     * Process the order.
     *
     * @param  string $number
     * @return \Ignite\Catalog\Entities\Order
     */
    public function process($number);

    /**
     * Delete the records with the given IDs.
     *
     * @param  string|array $ids
     * @return bool
     */
    public function delete($ids);
}
