<?php

namespace Ignite\Catalog\Models\Options;

use Ignite\Catalog\Entities\Catalog as CatalogModel;
use Ignite\Core\Contracts\Source;

class Catalog implements Source
{
    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        return CatalogModel::all()->keyBy('id')->map(function ($catalog) {
            if ($catalog->internal_name) {
                return ucwords($catalog->internal_name);
            }
            return ucwords($catalog->name);
        })->toArray();
    }
}
