<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Vendors\VendorHandler;
use Illuminate\Support\Collection;

class Reloadable extends VendorHandler
{
    /**
     * @inheritdoc
     */
    public function enabled()
    {
        return (bool) config('catalog.vendors.hawk.reloadable.enabled');
    }

    /**
     * @inheritdoc
     */
    protected function job(Order $order, Collection $orderItems)
    {
        return \Ignite\Catalog\Jobs\Hawk\Reloadable::class;
    }
}
