<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogTable extends Migration
{
    protected $tableName = 'catalog';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('catalog_vendor_id');
            $table->string('code', 100)->nullable();
            $table->string('name', 100);
            $table->string('type', 50);
            $table->string('description', 500)->nullable();
            $table->string('countries', 255);
            $table->boolean('active')->default(0);
            $table->timestamps();
            $table->foreign('catalog_vendor_id')->references('id')->on('catalog_vendor');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
