<?php

namespace Ignite\Catalog\Collections;

use Ignite\Catalog\Models\Product\BuyRequest;
use Illuminate\Support\Collection;

/**
 * @see \Ignite\Catalog\Entities\OrderItem
 */
class BuyRequestCollection extends Collection
{
    /**
     * @var bool
     */
    private $proceed = true;

    /**
     * Set whether the buy request can proceed.
     *
     * @param bool $flag
     *
     * @return self
     */
    public function setProceed(bool $flag)
    {
        $this->proceed = $flag;

        return $this;
    }

    /**
     * Determine whether the buy request can proceed.
     *
     * @return bool
     */
    public function canProceed()
    {
        return $this->proceed;
    }

    /**
     * Provide only item ids.
     *
     * @return self
     */
    public function getItemIds()
    {
        return $this->map(function (BuyRequest $buyRequest) {
            return $buyRequest->getItem()->getKey();
        });
    }

    /**
     * Determine whether the collection has the given Item ID.
     *
     * @param int $itemId
     *
     * @return bool
     */
    public function hasItemId(int $itemId)
    {
        return (bool) $this->filter(function (BuyRequest $buyRequest) use ($itemId) {
            return $buyRequest->getItemId() === $itemId;
        })->count();
    }

    /**
     * Find the given Item ID in the collection.
     *
     * @param int $itemId
     *
     * @return BuyRequest
     */
    public function getItemId(int $itemId)
    {
        return $this->filter(function (BuyRequest $buyRequest) use ($itemId) {
            return $buyRequest->getItemId() === $itemId;
        })->first();
    }
}
