<?php

namespace Ignite\Catalog\Contracts;

use Ignite\Catalog\Collections\BuyRequestCollection;
use Ignite\Catalog\Models\Product\BuyRequest;
use Ignite\Core\Entities\User;

interface CartRepository
{
    /**
     * Find cart items by a user. If a user is not provided, use the currently
     * logged in user. Optionally, pass whitelisted item ids to only return
     * those records.
     *
     * @param  User|null $user
     * @param  array     $whitelist
     * @return \Illuminate\Support\Collection
     */
    public function findByUser(User $user = null, array $whitelist = []);

    /**
     * Find all cart items. Not scoped by user.
     *
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public function findAll();

    /**
     * Find a cart item.
     *
     * @param  int       $id
     * @param  string    $column
     * @param  User|null $user
     * @return \Ignite\Catalog\Entities\CartItem
     */
    public function find($id, $column = 'id', User $user = null);

    /**
     * Find the total points in a user's cart. If the user is not specified, use the currently logged in user.
     *
     * @param  User|null $user
     * @return int
     */
    public function total(User $user = null);

    /**
     * Add an item to the cart.
     *
     * @param  BuyRequest $buyRequest
     * @return \Ignite\Catalog\Entities\CartItem
     */
    public function add(BuyRequest $buyRequest);

    /**
     * Remove an item from the cart.
     *
     * @param  int $id
     * @return \Ignite\Catalog\Entities\CartItem
     */
    public function remove($id);

    /**
     * Update item quantities by passing along a collection of buy requests.
     *
     * @param  BuyRequestCollection $buyRequests
     * @return \Illuminate\Support\Collection
     */
    public function updateQuantities(BuyRequestCollection $buyRequests);
}
