<?php

namespace Ignite\Catalog\Listeners;

use Ignite\Catalog\Emails\OrderConfirmation;
use Ignite\Catalog\Events\OrderSubmitted;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Mail;

class SendOrderConfirmation implements ShouldQueue
{
    use InteractsWithQueue;

    /**
     * Handle the event.
     *
     * @param OrderSubmitted $event
     *
     * @return void
     */
    public function handle(OrderSubmitted $event)
    {
        // TODO: Replace with a notification class?
        Mail::later(
            now()->addSeconds(30),
            (new OrderConfirmation($event->order))->locale($event->order->participant->language_preference ?? 'en')
        );
    }
}
