<?php

namespace Ignite\Catalog\Observers;

use Ignite\Catalog\Entities\Order;

class OrderObserver
{
    /**
     * Listen to the User created event.
     *
     * @param  \Ignite\Catalog\Entities\Order  $order
     * @return void
     */
    public function created(Order $order)
    {
        $prefix = config('catalog.order.prefix');
        $padding = config('catalog.order.padding');

        $number = $prefix . str_pad($order->getKey(), $padding, '0', STR_PAD_LEFT);

        $order->update([
            'number' => $number
        ]);
    }
}
