<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
    <h4 class="modal-title">{{ $orderItem->name }}</h4>
</div>
<div class="modal-body">
    @if ($orderItem->countVendorAttempts() > 0)
    <div class="panel-group" id="attempts" role="tablist" aria-multiselectable="true">
        @foreach ($orderItem->vendor_meta['attempts'] as $requestId => $attempt)
        <div class="panel panel-default">
            <div class="panel-heading" role="tab" id="attempt-heading-{{ $loop->index }}">
                <h4 class="panel-title">
                    <a class="collapsed" role="button" data-toggle="collapse" data-parent="#attempts" href="#attempt-{{ $loop->index }}" aria-expanded="false" aria-controls="attempt-{{ $loop->index }}">
                        Attempt #{{ $loop->index + 1 }} &middot; {{ $requestId }}
                    </a>
                </h4>
            </div>
            <div id="attempt-{{ $loop->index }}" class="panel-collapse collapse {{ $loop->last ? 'in' : '' }}" role="tabpanel" aria-labelledby="attempt-heading-{{ $loop->index }}">
                <div class="panel-body">
                    <p><strong>Vendor</strong>: {{ title_case(str_replace('_', ' ', snake_case($orderItem->vendor->name))) }}</p>

                    <p><strong>Amount</strong>: {{ $orderItem->getItemTotal() }}</p>

                    @if (isset($attempt['response']))
                        @foreach ($attempt['item'] as $key => $value)
                        <p><strong>{{ title_case(str_replace('_', ' ', snake_case($key))) }}</strong>: {{ $value }}</p>
                        @endforeach
                    @endif

                    @if (array_key_exists('errors', $attempt))
                        @include('Catalog::admin._partials.orders.items.attempt', [
                            'index' => $loop->index,
                            'errors' => $attempt['errors'],
                                'requestId' => $requestId,
                                'closable' => false,
                                'buttonLabel' => 'View'
                        ])
                    @endif

                    @if (isset($attempt['response']))
                        @if (isset($attempt['response']['errors']))
                            @include('Catalog::admin._partials.orders.items.attempt', [
                                'index' => $loop->index,
                                'errors' => $attempt['response']['errors'],
                                'requestId' => $requestId,
                                'closable' => false,
                                'buttonLabel' => 'View'
                            ])
                        @else
                            @foreach (array_dot($attempt['response']) as $key => $value)
                                <p><strong>{{ title_case(str_replace('_', ' ', snake_case($key))) }}</strong>:
                                @if ($key === 'success')
                                    {{ $value == 1 ? 'Yes' : 'No' }}
                                @elseif ($key === 'isCompleted')
                                    {{ $value == 1 ? 'Yes' : 'No' }}
                                @else
                                    {{ $value }}
                                @endif
                                </p>
                            @endforeach
                        @endif
                    @endif
                </div>
            </div>
        </div>
        @endforeach

        @if(isset($orderItem->vendor_meta['inspect']))
            <div class="panel-group" id="inspect" role="tablist" aria-multiselectable="true">
                <div class="panel panel-default">
                    <div class="panel-heading" role="tab" id="inspect-heading">
                        <h4 class="panel-title">
                            Order Status Response From Vendor
                        </h4>
                    </div>
                    <div id="inspect-0" class="panel-collapse" role="tabpanel" aria-labelledby="inspect-heading-0">
                        <div class="panel-body">
                        @foreach (array_dot($orderItem->vendor_meta['inspect']) as $key => $value)
                            <p><strong>{{ title_case(str_replace('_', ' ', snake_case($key))) }}</strong>: {{ $value }}</p>
                        @endforeach
                        </div>
                    </div>
                </div>
            </div>
        @endif

    </div>
    @else
        No communication with the vendor ({{ title_case(str_replace('_', ' ', snake_case($orderItem->vendor->name))) }}) has occurred yet.
    @endif
</div>

{{--
@if (! $orderItem->isProcessed() && $orderItem->isProcessable())
<div class="modal-footer">
    @if ($orderItem->countVendorAttempts() > 0)
    <a href="#" class="btn btn-default">Retry</a>
    @else
        <a href="#" class="btn btn-default">Queue</a>
    @endif
</div>
@endif
--}}
