<?php

namespace Ignite\Catalog\Providers;

use Ignite\Catalog\Console\Brightspot;
use Ignite\Catalog\Console\Hawk;
use Ignite\Catalog\Console\OrderCheck;
use Ignite\Catalog\Console\TangoImport;
use Illuminate\Support\ServiceProvider;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        Brightspot::class,
        Hawk::class,
        OrderCheck::class,
        TangoImport::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        $provides = $this->commands;

        return $provides;
    }
}
