<?php

namespace Ignite\Catalog\Http\Controllers\Admin;

use Ignite\Catalog\Entities\OrderItem;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Vendor\Hawk\Client;

class OrderItemsController extends Controller
{
    /**
     * Inspect the order item details.
     *
     * @param OrderItem $orderItem
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function inspect(OrderItem $orderItem)
    {
        $orderItem = $orderItem->load(['vendor']);
        $orderItem = $this->hasVendorMetaData($orderItem) ? $this->refreshOrderStatus($orderItem) : $orderItem;

        return view('Catalog::admin.orders.items.inspect', compact('orderItem'));
    }

    /**
     * @param  OrderItem $orderItem
     * @return OrderItem
     */
    protected function refreshOrderStatus(OrderItem $orderItem)
    {
        try {
            $vendorOrderNumber = $orderItem->order->vendor_order_number;
            $clientProgramNumber = $orderItem->vendor_meta['payload']['clientProgramNumber'];
            $requestId = key($orderItem->vendor_meta['attempts']);
            $orderInfoResponse = app(Client::class)
                ->orderInfo($vendorOrderNumber, $clientProgramNumber, $requestId)
                ->toArray();
        } catch (\Exception $e) {
            $orderInfoResponse = [
                'errors' => [
                    [
                        'errorCode' => $e->getCode(),
                        'message' => $e->getMessage(),
                    ],
                ],
            ];
        }

        $orderItem->vendor_meta = array_merge(
            $orderItem->vendor_meta,
            ['inspect' => $orderInfoResponse],
        );

        return $orderItem;
    }

    /**
     * @param  OrderItem $orderItem
     * @return boolean
     */
    protected function hasVendorMetaData(OrderItem $orderItem): bool
    {
        return isset($orderItem->vendor_meta['attempts']) && isset($orderItem->vendor_meta['payload']);
    }
}