<?php

namespace Ignite\Catalog\Http\Forms;

use Kris\LaravelFormBuilder\Form;

class VendorForm extends Form
{
    /**
     * Build the form.
     *
     * @return self
     */
    public function buildForm()
    {
        $this->add('name', 'text', $this->getNameOptions());
        $this->add('type', 'select', $this->getTypeOptions());
        $this->add('image_path', 'text', $this->getImagePathOptions());
        if (auth()->user()->hasGroup('admin')) {
            $this->add('redemption_class', 'text', $this->getRedemptionClassOptions());
        }
        $this->add('vendor_countries', 'choice', $this->getVendorCountriesOptions());
        $this->add('active', 'toggle', $this->getActiveOptions());
        $this->add('submit', 'submit', $this->getSaveButtonOptions());

        return $this;
    }

    /**
     * The options for the name field.
     *
     * @return array
     */
    protected function getNameOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.name.label'),
            'rules' => 'required|min:2|max:255'
        ];
    }

    /**
     * The options for the type field.
     *
     * @return array
     */
    protected function getTypeOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.type.label'),
            'rules' => 'max:50',
            'choices' => [
                'card' => 'Card',
                'merchandise' => 'Merchandise'
            ]
        ];
    }

    /**
     * The options for the image path field.
     *
     * @return array
     */
    protected function getImagePathOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.image_path.label'),
            'rules' => 'max:255'
        ];
    }

    /**
     * The options for the vendor countries field.
     *
     * @return array
     */
    protected function getVendorCountriesOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.vendor_countries.label'),
            'attr' => ['class' => 'form-control select2'],
            'rules' => 'max:255',
            'multiple' => true,
            'expanded' => false,
            'choices' => [
                'US' => 'USA',
                'CA' => 'Canada'
            ],
            'selected' => function ($data) {
                // Returns the array of short names from model relationship data
                return explode(',', $data);
            }
        ];
    }

    /**
     * The options for the redemption class field.
     *
     * @return array
     */
    protected function getRedemptionClassOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.redemption_class.label'),
            'rules' => 'max:255'
        ];
    }

    /**
     * The options for the active field.
     *
     * @return array
     */
    protected function getActiveOptions()
    {
        return [
            'label' => trans('Catalog::vendor.fields.active.label')
        ];
    }

    /**
     * The options for the save button.
     *
     * @return array
     */
    protected function getSaveButtonOptions()
    {
        return [
            'attr' => ['class' => 'btn btn-primary'],
            'label' => trans('Catalog::vendor.fields.save.label')
        ];
    }
}
