<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCatalogOrderItemTable extends Migration
{
    protected $tableName = 'catalog_order_item';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('catalog_order_id');
            $table->unsignedInteger('catalog_item_id');
            $table->unsignedInteger('catalog_vendor_id');
            $table->string('sku', 255)->nullable();
            $table->string('name', 255)->nullable();
            $table->string('type', 255)->nullable();
            $table->string('class', 255)->nullable();
            $table->integer('quantity');
            $table->integer('cost');
            $table->integer('point_value');
            $table->integer('points');
            $table->json('vendor_meta')->nullable();
            $table->integer('processed')->default(0);
            $table->integer('processed_quantity')->default(0);
            $table->timestamp('processed_at')->nullable();
            $table->integer('backordered')->default(0);
            $table->integer('backordered_quantity')->default(0);
            $table->timestamp('backordered_at')->nullable();
            $table->integer('shipped')->default(0);
            $table->integer('shipped_quantity')->default(0);
            $table->timestamp('shipped_at')->nullable();
            $table->integer('cancelled')->default(0);
            $table->integer('cancelled_quantity')->default(0);
            $table->timestamp('cancelled_at')->nullable();
            $table->timestamps();
            $table->foreign('catalog_order_id')->references('id')->on('catalog_order');
            $table->foreign('catalog_item_id')->references('id')->on('catalog_item');
            $table->foreign('catalog_vendor_id')->references('id')->on('catalog_vendor');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
