@extends('Catalog::layouts.master')

@section('page_heading', trans('Catalog::item.misc.show.heading', ['name' => $item->present()->getName()]))
@section('page_breadcrumb', trans('Catalog::item.misc.show.heading', ['name' => $item->present()->getName()]))

@section('page_content')

    <div class="row">
        <div class="col-sm-3">
            @component('Core::admin.components.menu-buttons')
                @if (isset($item))
                    @component('Core::admin.components.menu-button', ['link' => route('admin.catalog.items.edit', $item->getKey()), 'icon' => 'fa-fw fa-pencil'])
                        {{ trans('Core::core.buttons.edit') }}
                    @endcomponent
                @endif
                    @component('Core::admin.components.menu-button', ['link' => route('admin.catalog.items.index'), 'icon' => 'fa-chevron-left'])
                        {{ trans('Core::core.buttons.back_to_list') }}
                    @endcomponent
            @endcomponent
        </div>
        <div class="col-sm-9">
            @component('Core::admin.components.box')
                @slot('title')
                    {{ $item->present()->getName() }} ({{ $item->present()->getSku() }})
                @endslot
                @slot('tools')
                    <span class="badge bg-primary">{{ $item->present()->getType() }}</span>
                    @if ($item->present()->showBadge())
                        <span class="badge bg-primary">{{ $item->present()->getClassification() }}</span>
                    @endif
                @endslot
                    @component('Core::admin.components.data-list')
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.active.label'))
                            <span>{{ $item->present()->getActiveStatus() }}</span>
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.visibility.label'))
                            <span>{{ $item->present()->getVisibility() }}</span>
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.vendor_active.label'))
                            <span>{{ $item->present()->getVendorStatus() }}</span>
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.catalog_vendor_id.label'))
                            <span>{{ $item->present()->getVendorName() }}</span>
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.points.label'))
                            <span>{{ $item->present()->getPoints()  }}</span>
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.image.label'))
                            <img class="img-responsive item__image--rounded" src="{{ $item->getImageUrl() }}" />
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.description.label'))
                            {!! $item->present()->getDescription() !!}
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.terms.label'))
                            {!! $item->present()->getTerms() !!}
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.attributes.label'))
                            @if ($item->isConfigurable() && $item->getTypeInstance()->hasOptions())
                                @foreach ($item->getTypeInstance()->getOptions() as $option)
                                    @php $attribute = $option->first()->attribute; @endphp
                                    <label for="option-{{ $attribute->code }}" class="control">{{ $attribute->label }}</label>
                                    @foreach ($option as $opt)
                                        <p>{{ trans('Catalog::item.fields.id.label') }}: {{ $opt->item_id }} - {{ $opt->label }} - ({{ $opt->item->getPoints() }} points)</p>
                                    @endforeach
                                @endforeach
                            @endif
                        @endcomponent
                        @component('Core::admin.components.data-list-item', ['width' => '150px'])
                            @slot('label', trans('Catalog::item.fields.categories.label'))
                            <h4>
                                @foreach ($item->categories as $category)
                                    <span class="label label-primary">{{ $category->name }}</span>
                                @endforeach
                            </h4>
                        @endcomponent
                    @endcomponent
            @endcomponent
        </div>
    </div>

@endsection
