<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk;

use Ignite\Catalog\Models\Hawk\VirtualRecipient;
use Ignite\Tests\TestCase;

class VirtualRecipientTest extends TestCase
{
    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_can_create_an_instance_from_an_associative_array()
    {
        $this->assertInstanceOf(VirtualRecipient::class, VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => 'jsmith@gmail.com'
        ]));
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_first_name_exceeds_character_limit()
    {
        VirtualRecipient::fromAssociativeArray([
            'firstName' => str_repeat('X', 51),
            'lastName' => 'Smith',
            'email' => 'jsmith@gmail.com'
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_last_name_exceeds_character_limit()
    {
        VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => str_repeat('X', 51),
            'email' => 'jsmith@gmail.com'
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_email_exceeds_character_limit()
    {
        VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => str_repeat('X', 91)
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_email_is_invalid()
    {
        VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => 'invalid_email_address'
        ]);
    }

    /**
     * @test
     * @expectedException \InvalidArgumentException
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_fails_when_id_exceeds_character_limit()
    {
        VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => 'jsmith@gmail.com',
            'id' => str_repeat('X', 31)
        ]);
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_produces_the_expected_array_without_id()
    {
        $virtualRecipient = VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => 'jsmith@gmail.com'
        ]);

        $this->assertArrayNotHasKey('id', $virtualRecipient->toArray());
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     * @group ClosedLoop
     */
    public function it_produces_the_expected_array_with_id()
    {
        $virtualRecipient = VirtualRecipient::fromAssociativeArray([
            'firstName' => 'John',
            'lastName' => 'Smith',
            'email' => 'jsmith@gmail.com',
            'id' => 'ID1'
        ]);

        $this->assertArrayHasKey('id', $virtualRecipient->toArray());
    }
}
