<?php

use Ignite\Catalog\Entities\Item;
use Ignite\Catalog\Entities\OrderItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddVendorOrderNumberToOrderItem extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('catalog_order_item', 'vendor_order_number')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->string('vendor_order_number')->after('catalog_vendor_id')->nullable();
            });
        }

        $this->migrateVendorOrderNumber();
    }

    /**
     * Reverse the migrations.
     *
     * -------------------------------------------------- //
     * Be Careful!
     * -------------------------------------------------- //
     * This may drop data in the vendor_order_number
     * column if it pre-existed before the migration!
     * --------------------------------------------------
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('catalog_order_item', 'vendor_order_number')) {
            Schema::table('catalog_order_item', function (Blueprint $table) {
                $table->dropColumn('vendor_order_number');
            });
        }
    }

    /**
     * Migrate vendor order number.
     *
     * @return void
     */
    protected function migrateVendorOrderNumber(): void
    {
        // Do this for Hawk; Helix has its own migration
        $orderItems = OrderItem::query()->whereNull('vendor_order_number')->get();
        foreach ($orderItems as $orderItem) {
            if (empty($orderItem->vendor_meta['attempts'])) {
                continue;
            }

            $attempts = array_reverse($orderItem->vendor_meta['attempts']);
            foreach ($attempts as $attempt) {
                if (empty($attempt['response']['orderNumber'])) {
                    continue;
                }
                $orderItem->update(['vendor_order_number' => $attempt['response']['orderNumber']]);
                break;
            }
        }
    }
}
