<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterParticipantCreateReloadableFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('core_participant')) {
            return;
        }

        Schema::table('core_participant', function (Blueprint $table) {
            if (!Schema::hasColumn('core_participant', 'reloadable_id')) {
                $after = (Schema::hasColumn('core_participant', 'internal_notes') ? 'internal_notes'
                    : (Schema::hasColumn('core_participant', 'internal') ? 'internal' : null));
                if ($after) {
                    $table->string('reloadable_id')->nullable()->after($after);
                } else {
                    $table->string('reloadable_id')->nullable();
                }
            }
            if (!Schema::hasColumn('core_participant', 'reloadable_created_at')) {
                $table->timestamp('reloadable_created_at')->nullable()->after('reloadable_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (!Schema::hasTable('core_participant')) {
            return;
        }

        Schema::table('core_participant', function (Blueprint $table) {
            $table->dropColumn('reloadable_created_at');
            $table->dropColumn('reloadable_id');
        });
    }
}
