<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Core\Models\Grid\Formatter;

class AttributeFormatter extends Formatter
{
    /**
     * Format a checkbox for selecting entries in the grid.
     *
     * @param  \Ignite\Catalog\Entities\Attribute $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->id);
    }

    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Catalog\Entities\Attribute $model
     * @return HtmlString
     */
    public function actions($model)
    {
        $actions = [
            [
                'icon' => 'pencil',
                'label' => trans('Core::core.buttons.edit'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.attributes.edit', [
                    'attribute' => $model->id
                ])
            ],
            [
                'icon' => 'eye',
                'label' => trans('Core::core.buttons.view'),
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.attributes.show', [
                    'attribute' => $model->id
                ])
            ],
        ];

        return $this->html($this->buttons($actions));
    }

    /**
     * Format whether an order has been processed.
     *
     * @param  \Ignite\Catalog\Entities\Attribute $model
     * @return HtmlString
     */
    public function useInFilter($model)
    {
        return $this->html($this->formatYesNo(optional($model)->use_in_filter));
    }
}
