<?php

namespace Ignite\Catalog\Models\Product;

use Ignite\Catalog\Contracts\ProductType;
use Ignite\Catalog\Entities\Item;
use Illuminate\Contracts\Container\Container;

class ProductTypeFactory
{
    /**
     * @var array
     */
    protected $types = [];

    /**
     * @var Container
     */
    protected $container;

    /**
     * ClassificationFactory constructor.
     *
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * Make an instance of the given product type by name.
     *
     * @param string $name
     * @param Item $item
     *
     * @return ProductType
     * @throws \Illuminate\Contracts\Container\BindingResolutionException
     */
    public function make(string $name, Item $item)
    {
        $class = $this->types[$name];

        return $this->container->make($class, ['item' => $item]);
    }

    /**
     * Register an array of product types.
     *
     *  e.g. 'merchandise' => \Ignite\Catalog\Models\Product\Classifications\Merchandise::class
     *
     * @param array $types
     *
     * @return ProductTypeFactory
     */
    public function registerTypes(array $types)
    {
        foreach ($types as $name => $productType) {
            $this->register($name, $productType);
        }

        return $this;
    }

    /**
     * Register the product type.
     *
     * @param string $name
     * @param string $productType
     *
     * @return $this
     */
    public function register(string $name, string $productType)
    {
        $this->types[$name] = $productType;

        return $this;
    }
}
