# Changelog

## 3.0.24 - 2022-12-14

### Changes

- Added Ship Email column to Order Report 
- Added Ship Email column to Order Item Report

## 3.0.23 - 2022-12-06

### Changes

- Bug fixes: Whole orders were being canceled if one line item being canceled has the same quantity as the number of products (not quantity) in the order. This is usually because of how we save order quantity from Helix. Rather, we should check if all items in the order are canceled, and ignore catalog_order.quantity.

## 3.0.22 - 2022-11-23

### Changes

- Bug fixes: catalog_cart_item.status update not thoroughly flushed out. Several other methods need to account for using only active cart items, like total().
    - While it may fix many bugs with two separate shopping carts, there may be still some bugs especially if two tabs are opened. For instance, if two tabs are both in the checkout page for each cart, then submitting one could end up ordering from the other cart if the other cart was the last one that was "active". This hopefully is a rare situation and can be addressed later.
- Model/Cart attributes are now protected again instead of public. I will update in TTL Rewards accordingly to no longer expect these public attributes.
- Bug fixes: Fix NullProcessor to actually do nothing and not cause error. I guess it was never really used?
- Now when there is an Exception in InteractWithVendor, it logs as an error instead of as a debug, so it can be reported to Flare, and logged even if debug is turned off.

## 3.0.20 - 2022-09-21

### Changes

- Added a status column on catalog_cart_item table, updated cart model to pull only active items from the cart.
- Made properties in Cart public.

## 3.0.17 - 2022-07-22

### Changes

- Fix the command `ignite:catalog:order-check` so that it does not send email if there is nothing to process.
- Fix OrderReport and OrderItemReport: should not be displaying SSN, total on OrderReport is misleading, remove the fixed sorting, and making some other improvements.
- In `config/config.php`: I am pretty sure 'prepaidanonymousbulk' is suppose to be 'prepaid.anonymous.bulk' as the default configuration because that is the type stored in the database, how it is referenced in `Ignite\Catalog\Vendors\Hawk\Processor`, and how it is setup on one of our sites.

### Upgrading

- For OrderReport, you should not be referencing the 'total' field, but if you are, you may want to remove it because it may be inaccurate.

# 3.0.16 - 2022-05-31

### Changes
- Added Virtual to Hawk Vendors, Processor, and Jobs. Updated Item Entity and configuration file ([WDS-2570](https://brightspot.atlassian.net/browse/WDS-2570))

### Upgrading
To enable virtual cards (e.g. Virtual Mastercard) to an existing project, ensure the following has been added to catalog configuration file. 
```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            ...
            'virtual' => [
                'enabled' => env('CATALOG_HAWK_VIRTUAL_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_VIRTUAL_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_VIRTUAL_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - Virtual Order',
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_VIRTUAL_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            ...
        ],
    ],
]
```

## 3.0.15 - 2022-05-25

### Changes

- [X] Fixed `PrepaidAnonymousBulk::buildOrderLines()` so that the request will have only 1 line item since quantity is already built into the order line as an attribute. When the quantity is 3, it should order 1 item with quantity of 3, instead of 3 items each with a quantity of 3.
- [X] The catalog_favorite table has the super_id field default as 1, which should be default as null instead. When adding a favorite, it does not specify a super id, so it defaults to 1 incorrectly. And worst, if there is no catalog_item with id #1, then it has an error and you can not favorite the item.
- [X] Now when adding to a catalog favorite item, it should correctly get the super item id as well - no matter the default.
- [X] In Jobs/Hawk/Prepaid, the address.line1 should be reading from `catalog.vendors.hawk.address1` and not just `catalog.vendors.hawk.line1` since `catalog.vendors.hawk.address1` is that is in the config file.

### Upgrading

- You may want to selectively merge the latest copy of `config/config.php` into your `config/catalog.php`, especially with the new comments and `vendors.hawk.contact` default value.

## 3.0.14 - 2022-05-16

### Changes

- Removed formatter that formatted the number of digits after decimals except for points and price value on a catalog item.

## 3.0.13 - 2022-05-15

### Changes

- Updated `Jobs\Hawk\Base::getPaymentType()` to ensure the `vendor_meta['payment_type']` is checked against `Ignite\Vender\Hawk\PaymentType::getPaymentTypes()` array values or keys. This should ensure backward compatibility with other programs that only checked against the values.

## 3.0.10 - 2022-05-05

### Changes

- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))

### Upgrading

- If experiencing issues with `orderDetails.shippingMethod.invalid` check the catalog configuration file to ensure the shipping methods match the following defaults in Hawk Marketplace for the specified endpoint and Hawk product id. Refer to Hawk's [documentation](https://developer.blackhawknetwork.com/hawkmarketplace/docs/welcome)

```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            'prepaid' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
            'reloadable' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
    ...
]
```

###  3.0.10.* - Added New Feature

- [F] Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

# 3.0.9

- [X] Define user id for an order being cancel.

# 3.0.8

- [X] Return empty string, if item on a given orderItem does not exist.

# 3.0.7

- [F] Remove numeric characters from the shipping name. Hawk order fails with their existence.

# 3.0.6

- [F] Clean up the last name from ship-email in Hawks' eGift card order. Do not exceed the lastname characters by 30.

# 3.0.5

- [F] Core's points translation can be pluralized now. Updated code here for that update there.

# 3.0.4

- [F] Added OrderPermissionFilter. See ignite/core's version 3.0.30.

# 3.0.3

- [F] Added CATALOG_HAWK_TEST_MODE, which by defaults depends on the environment, but you can overwrite if you want to NOT test in local.
- [F] CATALOG_HAWK_CERT and CATALOG_HAWK_KEY are now auto-detected based on CATALOG_HAWK_TEST_MODE, so you do not need it in your .env
- [X] Removed distinct() from some queries because it may be hiding some bugs. Your query should return distinct values anyway and not need distinct() on most occasions. But if there are duplicate values or rows, then the distinct() could be hiding duplicate rows in the database or a bad join, and we need to see those instead not knowing of their existence.
- [X] It references the wrong class; the class GiftCard does not exists but Giftcard does.
- [X] Points fields are now double instead of decimal(10,4) so we can allow for million of points. All points fields should be the consistent type.

# 3.0.1

- [F] The JSON files for the seeders now can be replaced using the config config('core.seeder.path'). You can now have both core_page.json and core_page_catalog.json replacement files in your Program database/data folder without needing to create new seeder classes.
- [B] If you have existing db records for the catalog, then re-running the seeders may be overwrite those with the new defaults. You may want to create replace the default JSON files with your own in Program.
- [F] Several new composer scripts are available, including: php-security-checker, dos2unix, php-lint, php-code-beautify, php-code-style, and php-copy-paste-detector.
