<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Support\HtmlString;
use Ignite\Catalog\Entities\OrderItem;

class VendorOrderItemFormatter extends OrderItemFormatter
{

    /**
     * Custom column for actions.
     *
     * @param  OrderItem $item
     * @return HtmlString
     */
    public function actions(OrderItem $item)
    {
        $actions = [
            [
                'click' => '',
                'class' => '',
                'icon' => '',
                'label' => 'View Order',
                'text' => 'text-default',
                'type' => 'default',
                'link' => route('admin.catalog.orders.show', $item->order->number)
            ]
        ];

        return $this->html($this->buttons($actions));
    }
}
