<?php

return [
    'name' => 'Catalog',

    'disk' => 's3',

    /**
     * When there is only one active catalog in the database, should we redirect to that one directly? Or display the
     * catalog index page and ask the user to click on the catalog?
     */
    'redirect_when_only_one' => true,

    /**
     * On the catalog vendor index page and item page, should we display the type of item e.g. giftcard, egift etc
     * as a 'ribbon' on the item image?
     */
    'display_type_ribbon' => true,

    /**
     * On the catalog vendor index page, how many items should we display per page.
     */
    'per_page' => 15,

    /**
     * The default global point value conversion rate. Point value can also be changed per item.
     */
    'default_point_value' => 0.05,

    /**
     * The default global price margin. Price margin can also be changed per item.
     */
    'default_price_margin' => 13.04,

    'order' => [
        'prefix' => env('CATALOG_ORDER_PREFIX', 'IG'),
        'padding' => env('CATALOG_ORDER_PADDING', 6),
    ],

    'vendors' => [
        'hawk' => [
            // CATALOG_HAWK_TEST_MODE: if true, the catalog will connect to pre-prod Hawk
            // server with the integration cert and keys, otherwise it connects
            // to their production server with production the cert and key.
            // Also if it is true, it replaces all product_id with the
            // configured test product id upon ordering.
            'test_mode' => env('CATALOG_HAWK_TEST_MODE', 'production' !== env('APP_ENV')),
            'merchant_id' => env('CATALOG_HAWK_MERCHANT_ID'),
            // CATALOG_HAWK_CERT and CATALOG_HAWK_KEY will generate default file path if left empty
            'cert' => env('CATALOG_HAWK_CERT'),
            'key' => env('CATALOG_HAWK_KEY'),
            'prepaid' => [
                'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_PREPAID_TEST_ID', '43476908'),
                'payment_type' => env('CATALOG_HAWK_PREPAID_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'tax_id' => env('CATALOG_HAWK_PREPAID_TAX_ID'),
                'description' => env('CATALOG_HAWK_PREPAID_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_PREPAID_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                'card_carrier_message' => env('CATALOG_HAWK_PREPAID_CARD_CARRIER_MESSAGE', 'Congratulations on your award!'),
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
                'anonymous' => [
                    'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                    'bulk' => [
                        'enabled' => env('CATALOG_HAWK_PREPAID_ENABLED', false),
                        'description' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_DESCRIPTION', 'Prepaid Visa Card'),
                        'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', \Ignite\Vendor\Hawk\ShippingMethod::UPS_GROUND),
                        'payment_type' => env('CATALOG_HAWK_PREPAID_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                        'clientRefId' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_CLIENT_REF_ID', ''),
                        'fourthLineEmbossText' => env('CATALOG_HAWK_PREPAID_ANONYMOUS_BULK_FOURTH_LINE_TEXT', env('CATALOG_HAWK_PREPAID_FOURTH_LINE_EMBOSS', 'THANK YOU')),
                    ]
                ]
            ],
            'reloadable' => [
                'enabled' => env('CATALOG_HAWK_RELOADABLE_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_RELOADABLE_TEST_ID', '43531408'),
                'payment_type' => env('CATALOG_HAWK_RELOADABLE_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'description' => env('CATALOG_HAWK_RELOADABLE_DESCRIPTION', ''),
                'fourth_line_emboss' => env('CATALOG_HAWK_RELOADABLE_FOURTH_LINE_EMBOSS', 'THANK YOU'),
                'card_carrier_message' => env('CATALOG_HAWK_RELOADABLE_CARD_CARRIER_MESSAGE', ''),
                'shipping_method' => env('CATALOG_HAWK_RELOADABLE_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
                'identity_column' => 'user_id',
                'pid_column' => 'reloadable_pid',
            ],
            'giftcard' => [
                'enabled' => env('CATALOG_HAWK_GIFTCARD_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_GIFTCARD_TEST_ID', '43507508'),
                'payment_type' => env('CATALOG_HAWK_GIFTCARD_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT)
            ],
            'egift' => [
                'enabled' => env('CATALOG_HAWK_EGIFT_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_EGIFT_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_EGIFT_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - eGift Order',
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_EGIFT_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            'virtual' => [
                'enabled' => env('CATALOG_HAWK_VIRTUAL_ENABLED', false),
                'test_product_id' => env('CATALOG_HAWK_VIRTUAL_TEST_ID', '43479508'),
                'payment_type' => env('CATALOG_HAWK_VIRTUAL_PAYMENT_TYPE', Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT),
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - Virtual Order',
                // emailMessage - this cannot exceed 1024 characters
                // these tokens can be included: {first name}, {last name}, {amount}, and {email address}
                'emailMessage' => env('CATALOG_HAWK_VIRTUAL_MESSAGE', ''),
                'emailClosingName' => 'Reward Headquarters',
            ],
            'company' => 'Ignite Catalog Rewards',
            'contact' => 'Rewards Headquarters',
            'address1' => '102 Decker Ct Suite 150',
            'city' => 'Irving',
            'state' => 'TX',
            'zip' => '75062',
            'country' => 'US',
            'unsubscribe' => [
                'type' => 'EMAIL',
                'value' => 'it@brightspot.email'
            ],
            'schema' => [
                [
                    'name' => 'product_id',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Product ID'
                ], [
                    'name' => 'content_provider_code',
                    'type' => 'text',
                    'rules' => 'required',
                    'label' => 'Content Provider Code'
                ],
                /*
                [
                    'name' => 'payment_type',
                    'type' => 'select',
                    'rules' => 'required',
                    'label' => 'Payment Type',
                    'choices' => [
                        '' => 'Please choose a payment type',
                        Ignite\Vendor\Hawk\PaymentType::ACH_DEBIT => 'ACH DEBIT',
                        Ignite\Vendor\Hawk\PaymentType::ACH_CREDIT => 'ACH CREDIT',
                        Ignite\Vendor\Hawk\PaymentType::CREDIT_CARD => 'CREDIT CARD',
                        Ignite\Vendor\Hawk\PaymentType::WIRE_TRANSFER => 'WIRE TRANSFER',
                        Ignite\Vendor\Hawk\PaymentType::DRAW_DOWN => 'DRAW DOWN',
                        Ignite\Vendor\Hawk\PaymentType::BUSINESS_CHECK => 'BUSINESS CHECK',
                        Ignite\Vendor\Hawk\PaymentType::POST_PAY => 'POST PAY',
                    ],
                ],
                */
            ]
        ],

        // @deprecated: I dont think this is used anywhere
        'brightspot' => [
            "name" => "brightspot",
            "type" => "merchandise",
            "image_path" => "catalog/brightspot",
            "vendor_countries" => "US",
            "redemption_class" => Ignite\Catalog\Vendors\NullProcessor::class,
            "active" => 1
        ]
    ],

    'brightspot' => [
        "name" => "International Merchandise Catalog",
        "code" => "brightspot",
        "type" => "merchandise",
        "description" => "Example International merchandise catalog.",
        "countries" => "US",
        "active" => 1,
    ],

    'product' => [
        'types' => [
            'merchandise' => Ignite\Catalog\Models\Product\Classifications\Merchandise::class,
            'giftcard' => Ignite\Catalog\Models\Product\Classifications\Card::class,
            'egift' => Ignite\Catalog\Models\Product\Classifications\Egift::class,
            'prepaid' => Ignite\Catalog\Models\Product\Classifications\Prepaid::class,
            'reloadable' => Ignite\Catalog\Models\Product\Classifications\Reloadable::class,
            'prepaid.anonymous.bulk' => Ignite\Catalog\Models\Product\Classifications\PrepaidAnonymousBulk::class,
        ]
    ],

    'report' => [
        'filters' => [
            Ignite\Catalog\Models\Report\OrderReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order.created_at',
                    'options' => []
                ]
            ],
            Ignite\Catalog\Models\Report\OrderItemReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'label' => 'Order Date',
                    'field' => 'catalog_order_item.created_at',
                    'options' => []
                ]
            ]
        ]
    ]
];
