<?php

namespace Ignite\Catalog\Database\Seeders;

use Ignite\Catalog\Entities\Catalog;
use Ignite\Catalog\Entities\Menu;
use Ignite\Catalog\Entities\MenuItem;

class CatalogMenuItemTableSeeder extends AbstractCatalogSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'catalog_menu.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file),
            'headers' => true
        ]);

        $menus = $strategy->run();

        try {
            foreach ($menus as $menu) {
                $catalog = Catalog::where('code', $menu['catalog_code'])->first();
                $menu['catalog_id'] = $catalog->getKey();
                unset($menu['catalog_code']);

                Menu::updateOrCreate([
                    'catalog_id' => $menu['catalog_id'],
                    'name' => $menu['name']
                ], $menu);
            }
        } catch (\Exception $e) {
        }

        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('catalog_menu_item.json'),
            'headers' => true
        ]);

        $items = $strategy->run();

        try {
            foreach ($items as $item) {
                MenuItem::updateOrCreate([
                    'catalog_menu_id' => $item['catalog_menu_id'],
                    'catalog_category_id' => $item['catalog_category_id']
                ], $item);
            }
        } catch (\Exception $e) {
        }
    }
}
