<?php

namespace Ignite\Catalog\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Core\Models\Grid\QueryTable;
use Yajra\DataTables\DataTables;

class VendorsTable extends QueryTable
{
    /**
     * @var VendorFormatter
     */
    protected $formatter;

    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        VendorFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => trans('Core::core.common.actions'),
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => trans('Catalog::vendor.fields.id.label'),
                'name' => 'catalog_vendor.id',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => trans('Catalog::vendor.fields.name.label'),
                'name' => 'catalog_vendor.name',
                'orderable' => true,
                'exportable' => true,
            ],
            'type' => [
                'title' => trans('Catalog::vendor.fields.type.label'),
                'name' => 'catalog_vendor.type',
                'orderable' => true,
                'exportable' => true,
            ],
            'active' => [
                'title' => trans('Catalog::vendor.fields.active.label'),
                'name' => 'catalog_vendor.active',
                'orderable' => true,
                'exportable' => true,
            ],
            'image_path' => [
                'title' => trans('Catalog::vendor.fields.image_path.label'),
                'name' => 'catalog_vendor.image_path',
                'orderable' => true,
                'exportable' => true,
            ],
            'vendor_countries' => [
                'title' => trans('Catalog::vendor.fields.vendor_countries.label'),
                'name' => 'catalog_vendor.vendor_countries',
                'orderable' => true,
                'exportable' => true,
            ],
            'redemption_class' => [
                'title' => trans('Catalog::vendor.fields.redemption_class.label'),
                'name' => 'catalog_vendor.redemption_class',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => trans('Catalog::vendor.fields.created_at.label'),
                'name' => 'catalog_vendor.created_at',
                'orderable' => true,
                'exportable' => true,
                'visible' => true,
            ],
        ];
    }

    /**
     * The vendors query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions', 'checkbox')
            ->keys()
            ->toArray();

        $query = $this->getConnection()->table('catalog_vendor')
            ->select($columns)
            ->distinct();

        if ($this->status !== 'active') {
            $query->where('catalog_vendor.active', $this->status);
        }

        return $query;
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'checkbox' => [$this->formatter, 'checkbox'],
            'action' => [$this->formatter, 'actions'],
            'name' => [$this->formatter, 'name'],
            'active' => [$this->formatter, 'active'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            "order" => [2, 'asc'], // ID
        ], $this->getCheckboxColumnParameters());
    }
}
