<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class CategoryItem extends Model
{
    /** @var string */
    protected $table = 'catalog_category_item';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * The relationship to the item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function item()
    {
        return $this->belongsToMany(\Ignite\Catalog\Entities\Item::class, 'catalog_category_item', 'item_id', 'category_id');
    }

    /**
     * The relationship to the category.
     *
     * @return \Illuminate\Database\Eloquent\Relations\belongsTo
     */
    public function category()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Category::class, 'catalog_category_id', 'id');
    }
}
