<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Ignite\Catalog\Entities\Order;
use Ignite\Catalog\Entities\Vendor;
use Ignite\Catalog\Vendors\DispatchesOrderItems;
use Ignite\Catalog\Contracts\VendorHandler as VendorHandlerInterface;
use Illuminate\Support\Collection;

abstract class VendorHandler implements VendorHandlerInterface
{
    use DispatchesOrderItems;

    /**
     * @var Vendor
     */
    protected $vendor;

    /**
     * Egift constructor.
     *
     * @param Vendor $vendor
     */
    public function __construct(Vendor $vendor)
    {
        $this->vendor = $vendor;
    }

    /**
     * Handle the egift order items.
     *
     * @param  Order      $order
     * @param  Collection $orderItems
     */
    public function handle(Order $order, Collection $orderItems)
    {
        if (! $this->enabled()) {
            return;
        }

        $this->dispatchOrderItems($orderItems, $order, $this->job($order, $orderItems));
    }

    /**
     * Provide the fully qualified class name of the job handler.
     *
     * @param Order $order
     * @param Collection $orderItems
     *
     * @return mixed
     */
    abstract protected function job(Order $order, Collection $orderItems);
}
