<?php

namespace Ignite\Catalog\Models\Product\Classifications;

use Ignite\Catalog\Contracts\CardType;

class Reloadable extends Card implements CardType
{
    /**
     * Determine if this product type is a physical or virtual product.
     *
     * @return bool
     */
    public function isPhysical()
    {
        return true;
    }

    /**
     * Determine if this is open-loop (visa, mastercard, etc.)
     * or closed-loop (Amazon, Best Buy, merchants, etc.)
     *
     * @return bool
     */
    public function isOpenLoop()
    {
        return true;
    }

    /**
     * Determine if this product type is reloadable.
     *
     * @return bool
     */
    public function isReloadable()
    {
        return true;
    }
}
