- [F] New Feature /Enhancement
- [B] Breaking
- [X] Bug Fix

## 3.0.15 - 2022-05-25

### Changes

- [X] Fixed `PrepaidAnonymousBulk::buildOrderLines()` so that the request will have only 1 line item since quantity is already built into the order line as an attribute. When the quantity is 3, it should order 1 item with quantity of 3, instead of 3 items each with a quantity of 3.
- [X] The catalog_favorite table has the super_id field default as 1, which should be default as null instead. When adding a favorite, it does not specify a super id, so it defaults to 1 incorrectly. And worst, if there is no catalog_item with id #1, then it has an error and you can not favorite the item.
- [X] Now when adding to a catalog favorite item, it should correctly get the super item id as well - no matter the default.
- [X] In Jobs/Hawk/Prepaid, the address.line1 should be reading from `catalog.vendors.hawk.address1` and not just `catalog.vendors.hawk.line1` since `catalog.vendors.hawk.address1` is that is in the config file.

### Upgrading

- You may want to selectively merge the latest copy of `config/config.php` into your `config/catalog.php`, especially with the new comments and `vendors.hawk.contact` default value.

## 3.0.14 - 2022-05-16

### Changes

- Removed formatter that formatted the number of digits after decimals except for points and price value on a catalog item.

## 3.0.13 - 2022-05-15

### Changes

- Updated `Jobs\Hawk\Base::getPaymentType()` to ensure the `vendor_meta['payment_type']` is checked against `Ignite\Vender\Hawk\PaymentType::getPaymentTypes()` array values or keys. This should ensure backward compatibility with other programs that only checked against the values.

## 3.0.10 - 2022-05-05

### Changes

- Updated Shipping Methods to reflect Brightspot's current default shipping methods ([WDS-2580](https://brightspot.atlassian.net/jira/software/c/projects/BSDP/boards/28?modal=detail&selectedIssue=WDS-2580))

### Upgrading

- If experiencing issues with `orderDetails.shippingMethod.invalid` check the catalog configuration file to ensure the shipping methods match the following defaults in Hawk Marketplace for the specified endpoint and Hawk product id. Refer to Hawk's [documentation](https://developer.blackhawknetwork.com/hawkmarketplace/docs/welcome)

```php
app\config\catalog.php

[
    ...
    'vendors' => [
        'hawk' => [
            'prepaid' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
            'reloadable' => [
                ...
                'shipping_method' => env('CATALOG_HAWK_PREPAID_SHIPPING_METHOD', Ignite\Vendor\Hawk\ShippingMethod::USPS_FIRST_CLASS),
            ],
    ...
]
```

###  3.0.10.* - Added New Feature

- [F] Added SubmitOpenLoopAnonymousBulk Prepaid API End Point

# 3.0.9

- [X] Define user id for an order being cancel.

# 3.0.8

- [X] Return empty string, if item on a given orderItem does not exist.

# 3.0.7

- [F] Remove numeric characters from the shipping name. Hawk order fails with their existence.

# 3.0.6

- [F] Clean up the last name from ship-email in Hawks' eGift card order. Do not exceed the lastname characters by 30.

# 3.0.5

- [F] Core's points translation can be pluralized now. Updated code here for that update there.

# 3.0.4

- [F] Added OrderPermissionFilter. See ignite/core's version 3.0.30.

# 3.0.3

- [F] Added CATALOG_HAWK_TEST_MODE, which by defaults depends on the environment, but you can overwrite if you want to NOT test in local.
- [F] CATALOG_HAWK_CERT and CATALOG_HAWK_KEY are now auto-detected based on CATALOG_HAWK_TEST_MODE, so you do not need it in your .env
- [X] Removed distinct() from some queries because it may be hiding some bugs. Your query should return distinct values anyway and not need distinct() on most occasions. But if there are duplicate values or rows, then the distinct() could be hiding duplicate rows in the database or a bad join, and we need to see those instead not knowing of their existence.
- [X] It references the wrong class; the class GiftCard does not exists but Giftcard does.
- [X] Points fields are now double instead of decimal(10,4) so we can allow for million of points. All points fields should be the consistent type.

# 3.0.1

- [F] The JSON files for the seeders now can be replaced using the config config('core.seeder.path'). You can now have both core_page.json and core_page_catalog.json replacement files in your Program database/data folder without needing to create new seeder classes.
- [B] If you have existing db records for the catalog, then re-running the seeders may be overwrite those with the new defaults. You may want to create replace the default JSON files with your own in Program.
- [F] Several new composer scripts are available, including: php-security-checker, dos2unix, php-lint, php-code-beautify, php-code-style, and php-copy-paste-detector.
