<?php

namespace Ignite\Catalog\Entities;

use Illuminate\Database\Eloquent\Model;

class AttributeItem extends Model
{
    /** @var string */
    protected $table = 'catalog_attribute_item';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    protected $guarded = [];

    /**
     * The relationship to the associated items.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Item::class, 'item_id', 'id');
    }

    /**
     * The relationship to the super/parent item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function super()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Item::class, 'super_id', 'id');
    }

    /**
     * The options related to this attribute for the given item.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function attribute()
    {
        return $this->belongsTo(\Ignite\Catalog\Entities\Attribute::class, 'attribute_id', 'id');
    }
}
