<?php

namespace Ignite\Catalog\Vendors\Hawk;

use Illuminate\Support\Collection;
use Ignite\Catalog\Entities\Order;

class PrepaidAnonymousBulk extends VendorHandler
{
    /**
     * @inheritdoc
     */
    public function enabled(): bool
    {
        return (bool)config('catalog.vendors.hawk.prepaid.anonymous.bulk.enabled')
            ?? (bool)config('catalog.vendors.hawk.prepaid.anonymous.enabled')
            ?? (bool)config('catalog.vendors.hawk.prepaid.enabled');
    }

    /**
     * @inheritdoc
     */
    protected function job(Order $order, Collection $orderItems)
    {
        return \Ignite\Catalog\Jobs\Hawk\PrepaidAnonymousBulk::class;
    }
}
