<?php

namespace Ignite\Catalog\Models\Dashboard\Charts;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\Table;

class MostRecentOrdersTable extends Table
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label'   => 'Most recent orders',
            'color'   => 'primary',
            'icon'    => 'ion ion-ios-cart',
            'sort'    => 3,
            'headers' => $this->getHeaders()
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'recent-orders-list';
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-12 col-sm-4');
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var \Carbon\Carbon $start
             * @var \Carbon\Carbon $end
             */
            list($start, $end) = $this->getDateRange();

            $this->attributes['data'] = $this->buildQuery($start, $end);
        }

        return $this->get('data');
    }

    /**
     * Build the query.
     *
     * @param Carbon $start
     * @param Carbon $end
     *
     * @return \Illuminate\Support\Collection
     */
    protected function buildQuery(Carbon $start, Carbon $end)
    {
        DB::statement("SET SESSION sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''))");

        return DB::query()
            ->select(
                DB::raw('catalog_order_item.quantity as total'),
                'catalog_order_item.catalog_item_id as item_id',
                DB::raw('IF(LEFT(catalog_item.image, 4) = "http", catalog_item.image, CONCAT(catalog_vendor.image_path, "/", catalog_item.image)) as `image`'),
                'catalog_order_item.name as name',
                DB::raw('LOWER(REPLACE(catalog_vendor.name, " ", "-")) as subtitle')
            )
            ->from('catalog_order_item')
            ->leftJoin('catalog_item', 'catalog_order_item.catalog_item_id', '=', 'catalog_item.id')
            ->leftJoin('catalog_vendor', 'catalog_order_item.catalog_vendor_id', '=', 'catalog_vendor.id')
            ->groupBy('catalog_order_item.catalog_item_id', 'catalog_order_item.name', 'catalog_vendor.image_path')
            ->whereBetween('catalog_order_item.created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
            ->orderBy('catalog_order_item.created_at', 'desc')
            ->take(10)
            ->get();
    }

    /**
     * The table headers, if any.
     *
     * @return array
     */
    public function getHeaders()
    {
        return [];
    }
}
