<?php

namespace Ignite\Catalog\Contracts;

use Illuminate\Support\Collection;

interface CategoryRepository
{
    /**
     * The default query builder.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * Find a category by id.
     *
     * @param  int  $id
     * @return \Ignite\Catalog\Entities\Category
     */
    public function find($id);

    /**
     * Create a category.
     *
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Category
     */
    public function create(Collection $data);

    /**
     * Update a category.
     *
     * @param  int  $id
     * @param  Collection  $data
     * @return \Ignite\Catalog\Entities\Category
     */
    public function update(int $id, Collection $data);

    /**
     * Delete a category and any associated data.
     *
     * @param  int  $id
     * @return bool
     */
    public function delete(int $id);

    /**
     * Delete many categories and any associated data.
     *
     * @param  array  $ids
     * @return array
     */
    public function deleteMany(array $ids);
}
