<?php

namespace Ignite\Catalog\Http\Controllers\Api;

use Illuminate\Http\Request;
use Ignite\Catalog\Entities\Category;
use Ignite\Catalog\Entities\Menu;
use Ignite\Catalog\Entities\MenuItem;
use Ignite\Core\Http\Controllers\Controller;

class MenusController extends Controller
{
    /**
     * The list of menu items.
     *
     * @param  Menu $menu
     * @return \Illuminate\Http\JsonResponse
     */
    public function items(Menu $menu)
    {
        $data = MenuItem::with('category')
            ->where('catalog_menu_id', $menu->getKey())
            ->orderBy('position', 'asc')
            ->get()
            ->map(function (MenuItem $item) {
                return [
                    'catalog_menu_id' => (int) $item->catalog_menu_id,
                    'catalog_category_id' => (int) $item->catalog_category_id,
                    //'category_active' => (int) $item->category->active,
                    'active' => (int) $item->active,
                    'name' => $item->category->name,
                    'parent_id' => (int) $item->category->parent_id,
                    'id' => $item->getKey()
                ];
            });

        return response()->json($data->toArray());
    }

    /**
     * The categories that haven't yet been added to the menu.
     *
     * @param  Menu  $menu
     * @return \Illuminate\Http\JsonResponse
     */
    public function categories(Menu $menu)
    {
        $menuItems = MenuItem::query()
            ->where('catalog_menu_id', $menu->getKey())
            ->get()
            ->pluck('catalog_category_id')
            ->toArray();

        $categories = Category::whereNotIn('id', $menuItems)->get();

        return response()->json($categories->map(function ($category) {
            return [
                'id' => $category->getKey(),
                'text' => $category->name,
            ];
        }));
    }
}
