<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterPointsFieldsToDouble extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // making points fields consistent
        // and allowing points in the millions
        DB::statement("ALTER TABLE `catalog_cart_item` MODIFY COLUMN `points` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `point_value` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points_max` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points_min` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_order_item` MODIFY COLUMN `point_value` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_order_item` MODIFY COLUMN `points` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `catalog_order` MODIFY COLUMN `points` DOUBLE DEFAULT 0");
        DB::statement("ALTER TABLE `core_transaction_resource` MODIFY COLUMN `value` DOUBLE DEFAULT NULL");
        DB::statement("ALTER TABLE `core_transaction` MODIFY COLUMN `value` DOUBLE DEFAULT NULL");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement("ALTER TABLE `catalog_cart_item` MODIFY COLUMN `points` decimal(10,4) DEFAULT NULL");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `point_value` double(100,4) DEFAULT '0.0000'");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points_max` double(100,4) DEFAULT '0.0000'");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points_min` double(100,4) DEFAULT '0.0000'");
        DB::statement("ALTER TABLE `catalog_item` MODIFY COLUMN `points` double(100,4) DEFAULT '0.0000'");
        DB::statement("ALTER TABLE `catalog_order_item` MODIFY COLUMN `point_value` decimal(10,4) DEFAULT NULL");
        DB::statement("ALTER TABLE `catalog_order_item` MODIFY COLUMN `points` decimal(10,4) DEFAULT NULL");
        DB::statement("ALTER TABLE `catalog_order` MODIFY COLUMN `points` decimal(10,4) DEFAULT NULL");
        DB::statement("ALTER TABLE `core_transaction_resource` MODIFY COLUMN `value` DECIMAL(10,4) DEFAULT NULL");
        DB::statement("ALTER TABLE `core_transaction` MODIFY COLUMN `value` DECIMAL(10,4) DEFAULT NULL");
    }
}