<?php

namespace Ignite\Catalog\Tests\Unit\Models\Hawk;

use Ignite\Catalog\Models\Hawk\EmailContent;
use Ignite\Catalog\Models\Hawk\UnsubscribeData;
use Ignite\Tests\TestCase;

class EmailContentTest extends TestCase
{
    public function setUp() : void
    {
        parent::setUp();

        $this->app['config']->set('catalog.vendors.hawk', [
            'egift' => [
                'senderName' => 'Ignite Rewards',
                'senderEmail' => 'it@brightspot.email',
                'subject' => 'Catalog Rewards - eGift Order',
                'emailMessage' => '',
                'emailClosingName' => 'Reward Headquarters',
            ],
            'company' => 'Ignite Catalog Rewards',
            'address1' => '102 Decker Ct Suite 150',
            'city' => 'Irving',
            'state' => 'TX',
            'zip' => '75062',
            'country' => 'US',
            'unsubscribe' => [
                'type' => 'EMAIL',
                'value' => 'support@ttlrewards.com'
            ]
        ]);
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_resolve_the_instance_based_on_config_data()
    {
        $subject = 'My Program Rewards - eGift Order';

        $this->app['config']->set('catalog.vendors.hawk.egift.subject', $subject);

        $emailContent = $this->app->make(EmailContent::class);

        $this->assertEquals($subject, $emailContent->getSubject());
    }

    /**
     * @test
     * @group Catalog
     * @group Api
     * @group Vendor
     */
    public function it_can_ignore_the_emailmessage_when_the_value_is_empty()
    {
        $emailContent = new EmailContent('John Smith', 'js@gmail.com', 'Test', '', 'Test', $this->app->make(UnsubscribeData::class));

        $this->assertArrayNotHasKey('emailMessage', $emailContent->toArray());
    }
}
