<?php

namespace Ignite\Catalog\Models\Grid;

use Ignite\Core\Models\Grid\EloquentTable;
use Illuminate\Database\DatabaseManager;
use Ignite\Catalog\Entities\Order;
use Yajra\DataTables\DataTables;

class ParticipantOrderTable extends EloquentTable
{
    /**
     * The forms to look up for extra columns.
     * @var array
     */
    protected $forms = [];

    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [
        'idc'
    ];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [
        'actions', 'user_id'
    ];

    /**
     * @var OrderFormatter
     */
    protected $formatter;

    /**
     * ParticipantOrderTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param array $params
     * @param OrderFormatter $formatter
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        OrderFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'created_at' => [
                'title' => 'Created At',
                'name' => 'catalog_order.created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'items' => [
                'title' => 'Items',
                'name' => 'items',
                'orderable' => false,
                'searchable' => false,
                'exportable' => true,
            ],
            'ship_name' => [
                'title' => 'Name',
                'name' => 'catalog_order.ship_name',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_address_1' => [
                'title' => 'Address 1',
                'name' => 'catalog_order.ship_address_1',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_address_2' => [
                'title' => 'Address 2',
                'name' => 'catalog_order.ship_address_2',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_address_3' => [
                'title' => 'Address 2',
                'name' => 'catalog_order.ship_address_3',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_city' => [
                'title' => 'City',
                'name' => 'catalog_order.ship_city',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_state' => [
                'title' => 'State',
                'name' => 'catalog_order.ship_state',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_postal' => [
                'title' => 'Postal',
                'name' => 'catalog_order.ship_postal',
                'orderable' => true,
                'exportable' => true,
            ],
            'ship_phone' => [
                'title' => 'Phone',
                'name' => 'catalog_order.ship_phone',
                'orderable' => true,
                'exportable' => true,
            ],
            'processed' => [
                'title' => 'Processed?',
                'name' => 'catalog_order.processed',
                'orderable' => true,
                'exportable' => true,
            ],
            'cancelled' => [
                'title' => 'Cancelled?',
                'name' => 'catalog_order.cancelled',
                'orderable' => true,
                'exportable' => true,
            ],
            // Invisible columns
            'notes' => [
                'title' => 'Notes',
                'name' => 'catalog_order.notes',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'cancelled_at' => [
                'title' => 'Cancelled At',
                'name' => 'catalog_order.cancelled_at',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The participant orders query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        return Order::query()
            ->with('items', 'participant', 'user')
             ->where('catalog_order.user_id', '=', $this->user_id);
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'items' => [$this->formatter, 'items'],
            'processed' => [$this->formatter, 'processed'],
            'cancelled' => [$this->formatter, 'cancelled'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            'order' => [[1, 'asc']] // Created At
        ]);
    }
}
