<?php

namespace Ignite\Catalog\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Ignite\Catalog\Entities\OrderItem;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Catalog\Contracts\OrderRepository;
use Ignite\Catalog\Contracts\CatalogRepository;
use Ignite\Catalog\Models\Grid\OrderItemTable;

class OrderItemsController extends Controller
{
    /**
     * Inspect the order item details.
     *
     * @param  OrderItem $orderItem
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function inspect(OrderItem $orderItem)
    {
        $orderItem = $orderItem->load(['vendor']);

        return view('Catalog::admin.orders.items.inspect', compact('orderItem'));
    }
}
